<?php
/*
Plugin Name: WooCommerce Prefill Cart Link
Description: Allows adding products to cart via a special URL with product IDs and quantities.
Version: 1.0
Author: Critical Angle Studios
*/

// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

add_action('template_redirect', function () {
    if (isset($_GET['prefill_cart']) && isset($_GET['items']) && function_exists('WC')) {
        WC()->cart->empty_cart();

        $items = explode(',', $_GET['items']);
        foreach ($items as $item) {
            list($id, $qty) = array_pad(explode('-', $item), 2, 1);
            WC()->cart->add_to_cart((int) $id, max((int) $qty, 1));
        }

        wp_safe_redirect(wc_get_checkout_url());
        exit;
    }
});